/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.swing;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.swing.DoubleBoundedRangeModel;
import com.jsyn.swing.ExponentialRangeModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PortModelFactory {
    private static final int RESOLUTION = 1000000;

    public static DoubleBoundedRangeModel createLinearModel(final UnitInputPort unitInputPort) {
        final DoubleBoundedRangeModel doubleBoundedRangeModel = new DoubleBoundedRangeModel(unitInputPort.getName(), 1000000, unitInputPort.getMinimum(), unitInputPort.getMaximum(), unitInputPort.get());
        doubleBoundedRangeModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                unitInputPort.set(doubleBoundedRangeModel.getDoubleValue());
            }
        });
        return doubleBoundedRangeModel;
    }

    public static ExponentialRangeModel createExponentialModel(final UnitInputPort unitInputPort) {
        final ExponentialRangeModel exponentialRangeModel = new ExponentialRangeModel(unitInputPort.getName(), 1000000, unitInputPort.getMinimum(), unitInputPort.getMaximum(), unitInputPort.get());
        exponentialRangeModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                unitInputPort.set(exponentialRangeModel.getDoubleValue());
            }
        });
        return exponentialRangeModel;
    }

    public static ExponentialRangeModel createExponentialModel(final int n, final UnitInputPort unitInputPort) {
        final ExponentialRangeModel exponentialRangeModel = new ExponentialRangeModel(unitInputPort.getName(), 1000000, unitInputPort.getMinimum(), unitInputPort.getMaximum(), unitInputPort.get());
        exponentialRangeModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                unitInputPort.set(n, exponentialRangeModel.getDoubleValue());
            }
        });
        return exponentialRangeModel;
    }
}

