/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.scope.swing;

import com.jsyn.scope.WaveTraceModel;
import com.jsyn.swing.ExponentialRangeModel;
import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JToggleButton;

public class WaveTraceView {
    private static final double AUTO_DECAY = 0.95;
    private WaveTraceModel waveTraceModel;
    private Color color;
    private ExponentialRangeModel verticalScaleModel;
    private JToggleButton.ToggleButtonModel autoScaleButtonModel;
    private double xScaler;
    private double yScalar;
    private int centerY;

    public WaveTraceView(JToggleButton.ToggleButtonModel toggleButtonModel, ExponentialRangeModel exponentialRangeModel) {
        this.verticalScaleModel = exponentialRangeModel;
        this.autoScaleButtonModel = toggleButtonModel;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public ExponentialRangeModel getVerticalRangeModel() {
        return this.verticalScaleModel;
    }

    public JToggleButton.ToggleButtonModel getAutoButtonModel() {
        return this.autoScaleButtonModel;
    }

    public void setModel(WaveTraceModel waveTraceModel) {
        this.waveTraceModel = waveTraceModel;
    }

    public int convertRealToY(double d) {
        return this.centerY - (int)(this.yScalar * d);
    }

    public void drawWave(Graphics graphics, int n, int n2) {
        double d = 0.0;
        double d2 = 0.0;
        graphics.setColor(this.color);
        int n3 = this.waveTraceModel.getVisibleSize();
        if (n3 > 0) {
            this.xScaler = (double)n / (double)n3;
            this.yScalar = 0.5 * (double)n2 / this.verticalScaleModel.getDoubleValue();
            this.centerY = n2 / 2;
            int n4 = 0;
            int n5 = this.waveTraceModel.getStartIndex();
            double d3 = this.waveTraceModel.getSample(n5);
            int n6 = this.convertRealToY(d3);
            for (int i = 1; i < n3; ++i) {
                int n7 = (int)((double)i * this.xScaler);
                d3 = this.waveTraceModel.getSample(n5 + i);
                int n8 = this.convertRealToY(d3);
                graphics.drawLine(n4, n6, n7, n8);
                n4 = n7;
                n6 = n8;
                if (d3 > d) {
                    d = d3;
                    continue;
                }
                if (!(d3 < d2)) continue;
                d2 = d3;
            }
            this.autoScaleRange(d);
        }
    }

    private void autoScaleRange(double d) {
        if (this.autoScaleButtonModel.isSelected()) {
            double d2 = d * 1.1;
            double d3 = this.verticalScaleModel.getDoubleValue();
            if (d2 > d3) {
                this.verticalScaleModel.setDoubleValue(d2);
            } else {
                double d4 = d3 * 0.95;
                if (d4 > (double)this.verticalScaleModel.getMinimum() && d2 < d4) {
                    this.verticalScaleModel.setDoubleValue(d4);
                }
            }
        }
    }
}

