/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.ports;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.unitgen.UnitGenerator;
import com.softsynth.shared.time.ScheduledCommand;
import com.softsynth.shared.time.TimeStamp;

public class UnitGatePort
extends UnitInputPort {
    private boolean autoDisableEnabled = false;
    private boolean triggered = false;
    private boolean off = true;
    private UnitGenerator gatedUnit;
    public static final double THRESHOLD = 0.01;

    public UnitGatePort(String string) {
        super(string);
    }

    public void on() {
        this.setOn(true);
    }

    public void off() {
        this.setOn(false);
    }

    public void off(TimeStamp timeStamp) {
        this.setOn(false, timeStamp);
    }

    public void on(TimeStamp timeStamp) {
        this.setOn(true, timeStamp);
    }

    private void setOn(final boolean bl) {
        this.queueCommand(new ScheduledCommand(){

            @Override
            public void run() {
                UnitGatePort.this.setOnInternal(bl);
            }
        });
    }

    private void setOn(final boolean bl, TimeStamp timeStamp) {
        this.scheduleCommand(timeStamp, new ScheduledCommand(){

            @Override
            public void run() {
                UnitGatePort.this.setOnInternal(bl);
            }
        });
    }

    private void setOnInternal(boolean bl) {
        if (bl) {
            this.triggerInternal();
        }
        this.setValueInternal(bl ? 1.0 : 0.0);
    }

    private void triggerInternal() {
        this.getGatedUnit().setEnabled(true);
        this.triggered = true;
    }

    public void trigger() {
        this.queueCommand(new ScheduledCommand(){

            @Override
            public void run() {
                UnitGatePort.this.triggerInternal();
            }
        });
    }

    public void trigger(TimeStamp timeStamp) {
        this.scheduleCommand(timeStamp, new ScheduledCommand(){

            @Override
            public void run() {
                UnitGatePort.this.triggerInternal();
            }
        });
    }

    public boolean checkGate(int n) {
        double[] dArray = this.getValues();
        boolean bl = this.triggered;
        this.triggered = false;
        if (this.off) {
            if (dArray[n] >= 0.01) {
                bl = true;
                this.off = false;
            }
        } else if (dArray[n] < 0.01) {
            this.off = true;
        }
        return bl;
    }

    public boolean isOff() {
        return this.off;
    }

    public boolean isAutoDisableEnabled() {
        return this.autoDisableEnabled;
    }

    public void setAutoDisableEnabled(boolean bl) {
        this.autoDisableEnabled = bl;
    }

    public void checkAutoDisable() {
        if (this.autoDisableEnabled) {
            this.getGatedUnit().setEnabled(false);
        }
    }

    private UnitGenerator getGatedUnit() {
        return this.gatedUnit == null ? this.getUnitGenerator() : this.gatedUnit;
    }

    public void setupAutoDisable(UnitGenerator unitGenerator) {
        this.gatedUnit = unitGenerator;
        this.setAutoDisableEnabled(true);
        this.gatedUnit.setEnabled(false);
    }
}

