/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.devices.javasound;

import com.jsyn.devices.AudioDeviceInputStream;
import com.jsyn.devices.AudioDeviceManager;
import com.jsyn.devices.AudioDeviceOutputStream;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;

public class JavaSoundAudioDevice
implements AudioDeviceManager {
    private static final int BYTES_PER_SAMPLE = 2;
    private static final boolean USE_BIG_ENDIAN = false;
    ArrayList<DeviceInfo> deviceRecords;
    private double suggestedOutputLatency = 0.04;
    private double suggestedInputLatency = 0.1;
    private int defaultInputDeviceID = -1;
    private int defaultOutputDeviceID = -1;
    static Logger logger = Logger.getLogger(JavaSoundAudioDevice.class.getName());

    public JavaSoundAudioDevice() {
        String string = System.getProperty("os.name");
        if (string.contains("Windows")) {
            this.suggestedOutputLatency = 0.08;
            logger.info("JSyn: default output latency set to " + (int)(this.suggestedOutputLatency * 1000.0) + " msec for " + string);
        }
        this.deviceRecords = new ArrayList();
        this.sniffAvailableMixers();
        this.dumpAvailableMixers();
    }

    private void dumpAvailableMixers() {
        for (DeviceInfo deviceInfo : this.deviceRecords) {
            logger.fine("" + deviceInfo);
        }
    }

    private void sniffAvailableMixers() {
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        for (int i = 0; i < infoArray.length; ++i) {
            DeviceInfo deviceInfo = new DeviceInfo();
            deviceInfo.name = infoArray[i].getName();
            Mixer mixer = AudioSystem.getMixer(infoArray[i]);
            Line.Info[] infoArray2 = mixer.getTargetLineInfo();
            deviceInfo.maxInputs = this.scanMaxChannels(infoArray2);
            if (this.defaultInputDeviceID < 0 && deviceInfo.maxInputs > 0) {
                this.defaultInputDeviceID = i;
            }
            infoArray2 = mixer.getSourceLineInfo();
            deviceInfo.maxOutputs = this.scanMaxChannels(infoArray2);
            if (this.defaultOutputDeviceID < 0 && deviceInfo.maxOutputs > 0) {
                this.defaultOutputDeviceID = i;
            }
            this.deviceRecords.add(deviceInfo);
        }
    }

    private int scanMaxChannels(Line.Info[] infoArray) {
        int n = 0;
        for (Line.Info info : infoArray) {
            int n2;
            if (!(info instanceof DataLine.Info) || (n2 = this.scanMaxChannels((DataLine.Info)info)) <= n) continue;
            n = n2;
        }
        return n;
    }

    private int scanMaxChannels(DataLine.Info info) {
        int n = 0;
        for (AudioFormat audioFormat : info.getFormats()) {
            int n2 = audioFormat.getChannels();
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    @Override
    public AudioDeviceOutputStream createOutputStream(int n, int n2, int n3) {
        return new JavaSoundOutputStream(n, n2, n3);
    }

    @Override
    public AudioDeviceInputStream createInputStream(int n, int n2, int n3) {
        return new JavaSoundInputStream(n, n2, n3);
    }

    @Override
    public double getDefaultHighInputLatency(int n) {
        return 0.3;
    }

    @Override
    public double getDefaultHighOutputLatency(int n) {
        return 0.3;
    }

    @Override
    public int getDefaultInputDeviceID() {
        return this.defaultInputDeviceID;
    }

    @Override
    public int getDefaultOutputDeviceID() {
        return this.defaultOutputDeviceID;
    }

    @Override
    public double getDefaultLowInputLatency(int n) {
        return 0.1;
    }

    @Override
    public double getDefaultLowOutputLatency(int n) {
        return 0.1;
    }

    @Override
    public int getDeviceCount() {
        return this.deviceRecords.size();
    }

    @Override
    public String getDeviceName(int n) {
        return this.deviceRecords.get((int)n).name;
    }

    @Override
    public int getMaxInputChannels(int n) {
        return this.deviceRecords.get((int)n).maxInputs;
    }

    @Override
    public int getMaxOutputChannels(int n) {
        return this.deviceRecords.get((int)n).maxOutputs;
    }

    @Override
    public int setSuggestedOutputLatency(double d) {
        this.suggestedOutputLatency = d;
        return 0;
    }

    @Override
    public int setSuggestedInputLatency(double d) {
        this.suggestedInputLatency = d;
        return 0;
    }

    @Override
    public String getName() {
        return "JavaSound";
    }

    private class JavaSoundInputStream
    extends JavaSoundStream
    implements AudioDeviceInputStream {
        TargetDataLine line;

        public JavaSoundInputStream(int n, int n2, int n3) {
            super(n, n2, n3);
        }

        @Override
        public void start() {
            DataLine.Info info = new DataLine.Info(TargetDataLine.class, this.format);
            if (!AudioSystem.isLineSupported(info)) {
                logger.severe("JavaSoundInputStream - not supported." + this.format);
            } else {
                try {
                    this.line = (TargetDataLine)this.getDataLine(info);
                    int n = this.calculateBufferSize(JavaSoundAudioDevice.this.suggestedInputLatency);
                    this.line.open(this.format, n);
                    logger.fine("Input buffer size = " + n + " bytes.");
                    this.line.start();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    this.line = null;
                }
            }
        }

        @Override
        public double read() {
            double[] dArray = new double[1];
            this.read(dArray, 0, 1);
            return dArray[0];
        }

        @Override
        public int read(double[] dArray) {
            return this.read(dArray, 0, dArray.length);
        }

        @Override
        public int read(double[] dArray, int n, int n2) {
            if (this.bytes == null || this.bytes.length * 2 < n2) {
                this.bytes = new byte[n2 * 2];
            }
            int n3 = this.line.read(this.bytes, 0, this.bytes.length);
            int n4 = 0;
            for (int i = 0; i < n2; ++i) {
                int n5 = this.bytes[n4++] & 0xFF;
                dArray[i + n] = (double)(n5 += this.bytes[n4++] << 8) * 3.051850947599719E-5;
            }
            return n3 / 4;
        }

        @Override
        public void stop() {
            if (this.line != null) {
                this.line.drain();
                this.line.close();
            } else {
                new RuntimeException("AudioInput stop attempted when no line created.").printStackTrace();
            }
        }

        @Override
        public double getLatency() {
            if (this.line == null) {
                return 0.0;
            }
            int n = this.line.getBufferSize();
            int n2 = n / (2 * this.samplesPerFrame);
            return (double)n2 / (double)this.frameRate;
        }

        @Override
        public int available() {
            return this.line.available() / 2;
        }

        @Override
        public void close() {
        }
    }

    private class JavaSoundOutputStream
    extends JavaSoundStream
    implements AudioDeviceOutputStream {
        SourceDataLine line;

        public JavaSoundOutputStream(int n, int n2, int n3) {
            super(n, n2, n3);
        }

        @Override
        public void start() {
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, this.format);
            if (!AudioSystem.isLineSupported(info)) {
                logger.severe("JavaSoundOutputStream - not supported." + this.format);
            } else {
                try {
                    this.line = (SourceDataLine)this.getDataLine(info);
                    int n = this.calculateBufferSize(JavaSoundAudioDevice.this.suggestedOutputLatency);
                    this.line.open(this.format, n);
                    logger.fine("Output buffer size = " + n + " bytes.");
                    this.line.start();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    this.line = null;
                }
            }
        }

        @Override
        public void write(double d) {
            double[] dArray = new double[]{d};
            this.write(dArray, 0, 1);
        }

        @Override
        public void write(double[] dArray) {
            this.write(dArray, 0, dArray.length);
        }

        @Override
        public void write(double[] dArray, int n, int n2) {
            if (this.bytes == null || this.bytes.length * 2 < n2) {
                this.bytes = new byte[n2 * 2];
            }
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                double d = 32767.0 * dArray[i + n] + 32768.5;
                int n4 = (int)d - 32768;
                if (n4 > Short.MAX_VALUE) {
                    n4 = Short.MAX_VALUE;
                } else if (n4 < Short.MIN_VALUE) {
                    n4 = Short.MIN_VALUE;
                }
                this.bytes[n3++] = (byte)n4;
                this.bytes[n3++] = (byte)(n4 >> 8);
            }
            this.line.write(this.bytes, 0, n3);
        }

        @Override
        public void stop() {
            if (this.line != null) {
                this.line.stop();
                this.line.flush();
                this.line.close();
                this.line = null;
            } else {
                new RuntimeException("AudioOutput stop attempted when no line created.").printStackTrace();
            }
        }

        @Override
        public double getLatency() {
            if (this.line == null) {
                return 0.0;
            }
            int n = this.line.getBufferSize();
            int n2 = n / (2 * this.samplesPerFrame);
            return (double)n2 / (double)this.frameRate;
        }

        @Override
        public void close() {
        }
    }

    private class JavaSoundStream {
        AudioFormat format;
        byte[] bytes;
        int frameRate;
        int deviceID;
        int samplesPerFrame;

        public JavaSoundStream(int n, int n2, int n3) {
            this.deviceID = n;
            this.frameRate = n2;
            this.samplesPerFrame = n3;
            this.format = new AudioFormat(n2, 16, n3, true, false);
        }

        Line getDataLine(DataLine.Info info) throws LineUnavailableException {
            Line line;
            if (this.deviceID >= 0) {
                Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
                Mixer mixer = AudioSystem.getMixer(infoArray[this.deviceID]);
                line = mixer.getLine(info);
            } else {
                line = AudioSystem.getLine(info);
            }
            return line;
        }

        int calculateBufferSize(double d) {
            int n = (int)(d * (double)this.frameRate);
            int n2 = n * this.samplesPerFrame * 2;
            return n2;
        }
    }

    class DeviceInfo {
        String name;
        int maxInputs;
        int maxOutputs;

        DeviceInfo() {
        }

        public String toString() {
            return "AudioDevice: " + this.name + ", max in = " + this.maxInputs + ", max out = " + this.maxOutputs;
        }
    }
}

