/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.ports.UnitOutputPort;
import com.jsyn.ports.UnitVariablePort;
import com.jsyn.unitgen.UnitGenerator;
import com.jsyn.unitgen.UnitVoice;
import com.softsynth.shared.time.TimeStamp;

public abstract class UnitOscillator
extends UnitGenerator
implements UnitVoice {
    public UnitInputPort frequency = new UnitInputPort("Frequency");
    public UnitInputPort amplitude;
    public UnitVariablePort phase;
    public UnitOutputPort output;
    public static final double DEFAULT_FREQUENCY = 440.0;
    public static final double DEFAULT_AMPLITUDE = 1.0;

    public UnitOscillator() {
        this.addPort(this.frequency);
        this.frequency.setup(40.0, 440.0, 8000.0);
        this.amplitude = new UnitInputPort("Amplitude", 1.0);
        this.addPort(this.amplitude);
        this.phase = new UnitVariablePort("Phase");
        this.addPort(this.phase);
        this.output = new UnitOutputPort("Output");
        this.addPort(this.output);
    }

    public double convertFrequencyToPhaseIncrement(double d) {
        double d2;
        try {
            d2 = d * this.synthesisEngine.getInverseNyquist();
        }
        catch (NullPointerException nullPointerException) {
            throw new NullPointerException("Null Synth! You probably forgot to add this unit to the Synthesizer!");
        }
        d2 = d2 > 1.0 ? 1.0 : (d2 < -1.0 ? -1.0 : d2);
        return d2;
    }

    @Override
    public UnitOutputPort getOutput() {
        return this.output;
    }

    public void noteOn(double d, double d2) {
        this.frequency.set(d);
        this.amplitude.set(d2);
    }

    public void noteOff() {
        this.amplitude.set(0.0);
    }

    @Override
    public void noteOff(TimeStamp timeStamp) {
        this.amplitude.set(0.0, timeStamp);
    }

    @Override
    public void noteOn(double d, double d2, TimeStamp timeStamp) {
        this.frequency.set(d, timeStamp);
        this.amplitude.set(d2, timeStamp);
    }

    @Override
    public void usePreset(int n) {
    }
}

