/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.unitgen.UnitFilter;

public class InterpolatingDelay
extends UnitFilter {
    public UnitInputPort delay = new UnitInputPort("Delay");
    private float[] buffer;
    private int cursor;
    private int numFrames;

    public InterpolatingDelay() {
        this.addPort(this.delay);
    }

    public void allocate(int n) {
        this.numFrames = n;
        this.buffer = new float[n + 1];
    }

    @Override
    public void generate(int n, int n2) {
        double[] dArray = this.input.getValues();
        double[] dArray2 = this.output.getValues();
        double[] dArray3 = this.delay.getValues();
        for (int i = n; i < n2; ++i) {
            if (this.cursor == this.numFrames) {
                this.buffer[this.numFrames] = (float)dArray[i];
                this.cursor = 0;
            }
            this.buffer[this.cursor] = (float)dArray[i];
            double d = dArray3[i] * (double)this.getFrameRate();
            if (d <= 0.0) {
                dArray2[i] = this.buffer[this.cursor];
            } else {
                double d2;
                if (d >= (double)this.numFrames) {
                    d = this.numFrames - 1;
                }
                if ((d2 = (double)this.cursor - d) < 0.0) {
                    d2 += (double)this.numFrames;
                }
                int n3 = (int)d2;
                double d3 = d2 - (double)n3;
                double d4 = this.buffer[n3];
                double d5 = this.buffer[n3 + 1];
                dArray2[i] = d4 + d3 * (d5 - d4);
            }
            ++this.cursor;
        }
    }
}

