/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.swing;

import com.jsyn.swing.PresetSelectionListener;
import com.jsyn.util.InstrumentLibrary;
import com.jsyn.util.VoiceDescription;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.ArrayList;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class InstrumentBrowser
extends JPanel {
    private InstrumentLibrary library;
    private JScrollPane listScroller2;
    private VoiceDescription voiceDescription;
    private ArrayList<PresetSelectionListener> listeners = new ArrayList();

    public InstrumentBrowser(InstrumentLibrary instrumentLibrary) {
        this.library = instrumentLibrary;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 2));
        final JList<VoiceDescription> jList = new JList<VoiceDescription>(instrumentLibrary.getVoiceDescriptions());
        this.setupList(jList);
        jList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n;
                if (!listSelectionEvent.getValueIsAdjusting() && (n = jList.getSelectedIndex()) >= 0) {
                    InstrumentBrowser.this.showPresetList(n);
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(jList);
        jScrollPane.setPreferredSize(new Dimension(250, 120));
        this.add(jScrollPane);
        jList.setSelectedIndex(0);
    }

    public void addPresetSelectionListener(PresetSelectionListener presetSelectionListener) {
        this.listeners.add(presetSelectionListener);
    }

    public void removePresetSelectionListener(PresetSelectionListener presetSelectionListener) {
        this.listeners.remove(presetSelectionListener);
    }

    private void firePresetSelectionListeners(VoiceDescription voiceDescription, int n) {
        for (PresetSelectionListener presetSelectionListener : this.listeners) {
            presetSelectionListener.presetSelected(voiceDescription, n);
        }
    }

    private void showPresetList(int n) {
        if (this.listScroller2 != null) {
            this.remove(this.listScroller2);
        }
        this.voiceDescription = this.library.getVoiceDescriptions()[n];
        final JList<String> jList = new JList<String>(this.voiceDescription.getPresetNames());
        this.setupList(jList);
        jList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n;
                if (!listSelectionEvent.getValueIsAdjusting() && (n = jList.getSelectedIndex()) >= 0) {
                    InstrumentBrowser.this.firePresetSelectionListeners(InstrumentBrowser.this.voiceDescription, n);
                }
            }
        });
        this.listScroller2 = new JScrollPane(jList);
        this.listScroller2.setPreferredSize(new Dimension(250, 120));
        this.add(this.listScroller2);
        jList.setSelectedIndex(0);
        this.validate();
    }

    private void setupList(JList jList) {
        jList.setSelectionMode(1);
        jList.setLayoutOrientation(0);
        jList.setVisibleRowCount(-1);
    }
}

