/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.ports.UnitVariablePort;
import com.jsyn.unitgen.UnitFilter;

public class ContinuousRamp
extends UnitFilter {
    public UnitVariablePort current;
    public UnitInputPort time;
    private double previousInput = Double.MIN_VALUE;
    private double a;
    private double b;
    private double d;
    private int framesLeft;

    public ContinuousRamp() {
        this.time = new UnitInputPort(1, "Time", 1.0);
        this.addPort(this.time);
        this.current = new UnitVariablePort("Current");
        this.addPort(this.current);
    }

    @Override
    public void generate(int n, int n2) {
        double d;
        double[] dArray = this.output.getValues();
        double[] dArray2 = this.input.getValues();
        double d2 = this.time.getValues()[0];
        double d3 = d = this.current.getValue();
        for (int i = n; i < n2; ++i) {
            double d4;
            d3 = dArray2[i];
            if (d3 != this.previousInput) {
                d4 = this.framesLeft;
                double d5 = d4 * (3.0 * this.a * d4 + 2.0 * this.b);
                this.framesLeft = (int)((double)this.getSynthesisEngine().getFrameRate() * d2);
                if (this.framesLeft < 1) {
                    this.framesLeft = 1;
                }
                d4 = this.framesLeft;
                this.d = d3;
                double d6 = d4 * d4;
                this.b = (3.0 * d - d5 * d4 - 3.0 * this.d) / d6;
                this.a = (d5 - 2.0 * this.b * d4) / (3.0 * d6);
                this.previousInput = d3;
            }
            if (this.framesLeft > 0) {
                d4 = --this.framesLeft;
                d = d4 * (d4 * (d4 * this.a + this.b)) + this.d;
            }
            dArray[i] = d;
        }
        this.current.setValue(d);
    }
}

