/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.unitgen.GrainEnvelope;
import com.jsyn.unitgen.GrainSource;

public class Grain
implements GrainEnvelope {
    private double frameRate;
    private double amplitude = 1.0;
    private GrainSource source;
    private GrainEnvelope envelope;

    public Grain(GrainSource grainSource, GrainEnvelope grainEnvelope) {
        this.source = grainSource;
        this.envelope = grainEnvelope;
    }

    @Override
    public double next() {
        if (this.envelope.hasMoreValues()) {
            double d = this.envelope.next();
            return this.source.next() * d * this.amplitude;
        }
        return 0.0;
    }

    @Override
    public boolean hasMoreValues() {
        return this.envelope.hasMoreValues();
    }

    @Override
    public void reset() {
        this.source.reset();
        this.envelope.reset();
    }

    public void setRate(double d) {
        this.source.setRate(d);
    }

    @Override
    public void setDuration(double d) {
        this.envelope.setDuration(d);
    }

    @Override
    public double getFrameRate() {
        return this.frameRate;
    }

    @Override
    public void setFrameRate(double d) {
        this.frameRate = d;
        this.source.setFrameRate(d);
        this.envelope.setFrameRate(d);
    }

    public double getAmplitude() {
        return this.amplitude;
    }

    public void setAmplitude(double d) {
        this.amplitude = d;
    }

    public GrainSource getSource() {
        return this.source;
    }
}

