/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.util;

import com.jsyn.io.AudioInputStream;
import com.jsyn.io.AudioOutputStream;
import com.jsyn.util.TransportModel;
import java.io.IOException;

public class StreamingThread
extends Thread {
    private AudioInputStream inputStream;
    private AudioOutputStream outputStream;
    private int framesPerBuffer = 1024;
    private volatile boolean go = true;
    private TransportModel transportModel;
    private long framePosition;
    private long maxFrames;
    private int samplesPerFrame = 1;

    public StreamingThread(AudioInputStream audioInputStream, AudioOutputStream audioOutputStream) {
        this.inputStream = audioInputStream;
        this.outputStream = audioOutputStream;
    }

    @Override
    public void run() {
        double[] dArray = new double[this.framesPerBuffer * this.samplesPerFrame];
        try {
            this.transportModel.firePositionChanged(this.framePosition);
            this.transportModel.fireStateChanged(2);
            int n = this.geteFramesToRead(dArray);
            while (this.go && n > 0) {
                int n2;
                for (int i = n * this.samplesPerFrame; i > 0; i -= n2) {
                    n2 = this.inputStream.read(dArray, 0, i);
                    this.outputStream.write(dArray, 0, n2);
                }
                this.framePosition += (long)n;
                this.transportModel.firePositionChanged(this.framePosition);
                n = this.geteFramesToRead(dArray);
            }
            this.transportModel.fireStateChanged(0);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private int geteFramesToRead(double[] dArray) {
        if (this.maxFrames > 0L) {
            long l = this.maxFrames - this.framePosition;
            if (l < 0L) {
                return 0;
            }
            if (l > (long)this.framesPerBuffer) {
                l = this.framesPerBuffer;
            }
            return (int)l;
        }
        return this.framesPerBuffer;
    }

    public int getFramesPerBuffer() {
        return this.framesPerBuffer;
    }

    public void setFramesPerBuffer(int n) {
        this.framesPerBuffer = n;
    }

    public void requestStop() {
        this.go = false;
    }

    public TransportModel getTransportModel() {
        return this.transportModel;
    }

    public void setTransportModel(TransportModel transportModel) {
        this.transportModel = transportModel;
    }

    public void setMaxFrames(long l) {
        this.maxFrames = l;
    }

    public int getSamplesPerFrame() {
        return this.samplesPerFrame;
    }

    public void setSamplesPerFrame(int n) {
        this.samplesPerFrame = n;
    }
}

