/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.engine.SynthesisEngine;
import com.jsyn.ports.UnitPort;
import com.jsyn.unitgen.UnitGenerator;
import java.util.ArrayList;
import java.util.LinkedHashMap;

public class Circuit
extends UnitGenerator {
    private ArrayList<UnitGenerator> units = new ArrayList();
    private final LinkedHashMap<String, UnitPort> portAliases = new LinkedHashMap();

    @Override
    public void generate(int n, int n2) {
        for (UnitGenerator unitGenerator : this.units) {
            unitGenerator.generate(n, n2);
        }
    }

    @Override
    public void flattenOutputs() {
        for (UnitGenerator unitGenerator : this.units) {
            unitGenerator.flattenOutputs();
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        for (UnitGenerator unitGenerator : this.units) {
            unitGenerator.setEnabled(bl);
        }
    }

    @Override
    @Deprecated
    public void setFrameRate(int n) {
        super.setFrameRate(n);
        for (UnitGenerator unitGenerator : this.units) {
            unitGenerator.setFrameRate(n);
        }
    }

    @Override
    public void setSynthesisEngine(SynthesisEngine synthesisEngine) {
        super.setSynthesisEngine(synthesisEngine);
        for (UnitGenerator unitGenerator : this.units) {
            unitGenerator.setSynthesisEngine(synthesisEngine);
        }
    }

    public void add(UnitGenerator unitGenerator) {
        this.units.add(unitGenerator);
        unitGenerator.setCircuit(this);
        unitGenerator.setEnabled(this.isEnabled());
    }

    public void usePreset(int n) {
    }

    public void addPortAlias(UnitPort unitPort, String string) {
        this.portAliases.put(string.toLowerCase(), unitPort);
    }

    @Override
    public UnitPort getPortByName(String string) {
        UnitPort unitPort = super.getPortByName(string);
        if (unitPort == null) {
            unitPort = this.portAliases.get(string.toLowerCase());
        }
        return unitPort;
    }
}

