/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.unitgen.TunableFilter;

public abstract class FilterBiquad
extends TunableFilter {
    public UnitInputPort amplitude = new UnitInputPort("Amplitude", 1.0);
    protected static final double MINIMUM_FREQUENCY = 1.0E-5;
    protected static final double MINIMUM_GAIN = 1.0E-5;
    protected static final double RATIO_MINIMUM = 0.499;
    protected double a0;
    protected double a1;
    protected double a2;
    protected double b1;
    protected double b2;
    private double x1;
    private double x2;
    private double y1;
    private double y2;
    protected double previousFrequency;
    protected double omega;
    protected double sin_omega;
    protected double cos_omega;

    public FilterBiquad() {
        this.addPort(this.amplitude);
    }

    @Override
    public void generate(int n, int n2) {
        this.recalculate();
        this.performBiquadFilter(n, n2);
    }

    protected abstract void recalculate();

    public void performBiquadFilter(int n, int n2) {
        double[] dArray = this.input.getValues();
        double[] dArray2 = this.amplitude.getValues();
        double[] dArray3 = this.output.getValues();
        double d = this.x1;
        double d2 = this.x2;
        double d3 = this.y1;
        double d4 = this.y2;
        double d5 = this.a0;
        double d6 = this.a1;
        double d7 = this.a2;
        double d8 = this.b1;
        double d9 = this.b2;
        for (int i = n; i < n2; i += 2) {
            double d10 = dArray[i];
            d4 = d5 * d10 + d6 * d + d7 * d2 - d8 * d3 - d9 * d4;
            dArray3[i] = dArray2[i] * d4;
            d2 = dArray[i + 1];
            d3 = d5 * d2 + d6 * d10 + d7 * d - d8 * d4 - d9 * d3;
            dArray3[i + 1] = dArray2[i + 1] * d3;
            d = d2;
            d2 = d10;
        }
        this.x1 = d;
        this.x2 = d2;
        this.y1 = d3 + 1.0E-26;
        this.y2 = d4 - 1.0E-26;
    }

    protected void calculateOmega(double d) {
        if (d >= 0.499) {
            d = 0.499;
        }
        this.omega = Math.PI * 2 * d;
        this.cos_omega = Math.cos(this.omega);
        this.sin_omega = Math.sin(this.omega);
    }
}

