/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.util.soundfile;

import com.jsyn.util.soundfile.ChunkHandler;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

class IFFParser
extends FilterInputStream {
    private long numBytesRead = 0L;
    private long totalSize = 0L;
    private int fileId;
    static boolean debug = false;
    public static final int RIFF_ID = 1380533830;
    public static final int LIST_ID = 1279873876;
    public static final int FORM_ID = 1179603533;

    IFFParser(InputStream inputStream) {
        super(inputStream);
    }

    public long getFileSize() {
        return this.totalSize;
    }

    public long getOffset() {
        return this.numBytesRead;
    }

    @Override
    public int read() throws IOException {
        ++this.numBytesRead;
        return super.read();
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4 = n;
        for (int i = n2; i > 0; i -= n3) {
            n3 = super.read(byArray, n4, i);
            if (n3 < 0) {
                return n3;
            }
            n4 += n3;
            this.numBytesRead += (long)n3;
        }
        return n4 - n;
    }

    @Override
    public long skip(long l) throws IOException {
        this.numBytesRead += l;
        return super.skip(l);
    }

    public int readIntBig() throws IOException {
        int n = this.read() & 0xFF;
        n = n << 8 | this.read() & 0xFF;
        n = n << 8 | this.read() & 0xFF;
        int n2 = this.read();
        if (n2 == -1) {
            throw new EOFException("readIntBig() - EOF in middle of word at offset " + this.numBytesRead);
        }
        n = n << 8 | n2 & 0xFF;
        return n;
    }

    public int readIntLittle() throws IOException {
        int n = this.read() & 0xFF;
        n |= (this.read() & 0xFF) << 8;
        n |= (this.read() & 0xFF) << 16;
        int n2 = this.read();
        if (n2 == -1) {
            throw new EOFException("readIntLittle() - EOF in middle of word at offset " + this.numBytesRead);
        }
        return n |= n2 << 24;
    }

    public short readShortBig() throws IOException {
        short s = (short)(this.read() << 8);
        int n = this.read();
        if (n == -1) {
            throw new EOFException("readShortBig() - EOF in middle of word at offset " + this.numBytesRead);
        }
        s = (short)(s | n & 0xFF);
        return s;
    }

    public short readShortLittle() throws IOException {
        short s = (short)(this.read() & 0xFF);
        int n = this.read();
        if (n == -1) {
            throw new EOFException("readShortLittle() - EOF in middle of word at offset " + this.numBytesRead);
        }
        s = (short)(s | n << 8);
        return s;
    }

    public int readUShortLittle() throws IOException {
        return this.readShortLittle() & 0xFFFF;
    }

    public byte readByte() throws IOException {
        return (byte)this.read();
    }

    public int readChunkSize() throws IOException {
        if (this.isRIFF()) {
            return this.readIntLittle();
        }
        return this.readIntBig();
    }

    public static String IDToString(int n) {
        byte[] byArray = new byte[]{(byte)(n >> 24), (byte)(n >> 16), (byte)(n >> 8), (byte)n};
        return new String(byArray);
    }

    public void parseAfterHead(ChunkHandler chunkHandler) throws IOException {
        int n = this.readChunkSize();
        this.totalSize = n + 8;
        this.parseChunk(chunkHandler, this.fileId, n);
        if (debug) {
            System.out.println("parse() ------- end");
        }
    }

    void parseForm(ChunkHandler chunkHandler, int n, int n2, int n3) throws IOException {
        if (debug) {
            System.out.println("IFF: parseForm >>>>>>>>>>>>>>>>>> BEGIN");
        }
        while (n2 > 8) {
            int n4 = this.readIntBig();
            int n5 = this.readChunkSize();
            n2 -= 8;
            if (debug) {
                System.out.println("chunk( " + IFFParser.IDToString(n4) + ", " + n5 + " )");
            }
            if (n5 < 0) {
                throw new IOException("Bad IFF chunk Size: " + IFFParser.IDToString(n4) + " = 0x" + Integer.toHexString(n4) + ", Size = " + n5);
            }
            this.parseChunk(chunkHandler, n4, n5);
            if ((n5 & 1) == 1) {
                ++n5;
            }
            n2 -= n5;
            if (!debug) continue;
            System.out.println("parseForm: numBytes left in form = " + n2);
        }
        if (debug) {
            System.out.println("IFF: parseForm <<<<<<<<<<<<<<<<<<<< END");
        }
        if (n2 > 0) {
            System.out.println("IFF Parser detected " + n2 + " bytes of garbage at end of FORM.");
            this.skip(n2);
        }
    }

    void parseChunk(ChunkHandler chunkHandler, int n, int n2) throws IOException {
        int n3;
        long l;
        long l2 = this.getOffset();
        if (this.isForm(n)) {
            int n4 = this.readIntBig();
            if (debug) {
                System.out.println("parseChunk:    form = " + IFFParser.IDToString(n) + ", " + n2 + ", " + IFFParser.IDToString(n4));
            }
            chunkHandler.handleForm(this, n, n2 - 4, n4);
            l = this.getOffset();
            n3 = (int)(l - l2);
            if (n3 < n2) {
                this.parseForm(chunkHandler, n, n2 - n3, n4);
            }
        } else {
            chunkHandler.handleChunk(this, n, n2);
        }
        l = this.getOffset();
        n3 = (int)(l - l2);
        if (debug) {
            System.out.println("parseChunk:    endOffset = " + l);
            System.out.println("parseChunk:    numRead = " + n3);
        }
        if ((n2 & 1) == 1) {
            ++n2;
        }
        if (n3 < n2) {
            this.skip(n2 - n3);
        }
    }

    public void readHead() throws IOException {
        if (debug) {
            System.out.println("parse() ------- begin");
        }
        this.numBytesRead = 0L;
        this.fileId = this.readIntBig();
    }

    public boolean isRIFF() {
        return this.fileId == 1380533830;
    }

    public boolean isIFF() {
        return this.fileId == 1179603533;
    }

    public boolean isForm(int n) {
        if (this.isRIFF()) {
            switch (n) {
                case 1279873876: 
                case 1380533830: {
                    return true;
                }
            }
            return false;
        }
        switch (n) {
            case 1179603533: 
            case 1279873876: {
                return true;
            }
        }
        return false;
    }
}

