/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.midi;

public class MessageParser {
    private int[] parameterIndices = new int[16];
    private int[] parameterValues = new int[16];
    private int BIT_NON_RPM = 16384;
    private int MASK_14BIT = 16383;

    public void parse(byte[] byArray) {
        byte by = byArray[0];
        int n = by & 0xF0;
        int n2 = by & 0xF;
        switch (n) {
            case 144: {
                byte by2 = byArray[2];
                if (by2 == 0) {
                    this.noteOff(n2, byArray[1], by2);
                    break;
                }
                this.noteOn(n2, byArray[1], by2);
                break;
            }
            case 128: {
                this.noteOff(n2, byArray[1], byArray[2]);
                break;
            }
            case 160: {
                this.polyphonicAftertouch(n2, byArray[1], byArray[2]);
                break;
            }
            case 208: {
                this.channelPressure(n2, byArray[1]);
                break;
            }
            case 176: {
                this.rawControlChange(n2, byArray[1], byArray[2]);
                break;
            }
            case 192: {
                this.programChange(n2, byArray[1]);
                break;
            }
            case 224: {
                int n3 = (byArray[2] << 7) + byArray[1];
                this.pitchBend(n2, n3);
            }
        }
    }

    public void rawControlChange(int n, int n2, int n3) {
        switch (n2) {
            case 6: {
                this.parameterValues[n] = n3 << 7;
                this.fireParameterChange(n);
                break;
            }
            case 38: {
                int n4 = this.parameterValues[n] & 0xFFFFFF80;
                this.parameterValues[n] = n4 |= n3;
                this.fireParameterChange(n);
                break;
            }
            case 98: {
                int n5 = this.parameterIndices[n] & 0xFFFFFF80;
                this.parameterIndices[n] = n5 |= n3 | this.BIT_NON_RPM;
                break;
            }
            case 99: {
                this.parameterIndices[n] = n3 << 7 | this.BIT_NON_RPM;
                break;
            }
            case 100: {
                int n6 = this.parameterIndices[n] & 0xFFFFFF80;
                this.parameterIndices[n] = n6 |= n3;
                break;
            }
            case 101: {
                this.parameterIndices[n] = n3 << 7;
                break;
            }
            default: {
                this.controlChange(n, n2, n3);
            }
        }
    }

    private void fireParameterChange(int n) {
        int n2 = this.parameterIndices[n];
        if ((n2 & this.BIT_NON_RPM) == 0) {
            this.registeredParameter(n, n2, this.parameterValues[n]);
        } else {
            this.nonRegisteredParameter(n, n2 & this.MASK_14BIT, this.parameterValues[n]);
        }
    }

    public void nonRegisteredParameter(int n, int n2, int n3) {
    }

    public void registeredParameter(int n, int n2, int n3) {
    }

    public void pitchBend(int n, int n2) {
    }

    public void programChange(int n, int n2) {
    }

    public void polyphonicAftertouch(int n, int n2, int n3) {
    }

    public void channelPressure(int n, int n2) {
    }

    public void controlChange(int n, int n2, int n3) {
    }

    public void noteOn(int n, int n2, int n3) {
    }

    public void noteOff(int n, int n2, int n3) {
    }
}

