/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.util;

import java.util.Random;

public class RecursiveSequenceGenerator {
    private int delay = 1;
    private int maxValue;
    private int maxInterval;
    private double desiredDensity = 0.5;
    private int offset;
    private int[] values;
    private boolean[] enables;
    private int cursor;
    private int countdown = -1;
    private double actualDensity;
    private int beatsPerMeasure = 8;
    private Random random;

    public RecursiveSequenceGenerator() {
        this(25, 7, 64);
    }

    public RecursiveSequenceGenerator(int n, int n2, int n3) {
        this.values = new int[n3];
        this.enables = new boolean[n3];
        this.maxValue = n;
        this.maxInterval = n2;
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = n / 2;
            this.enables[i] = this.isNextEnabled(false);
        }
    }

    public void setDensity(double d) {
        this.desiredDensity = d;
    }

    public double getDensity() {
        return this.desiredDensity;
    }

    public void setMaxValue(int n) {
        this.maxValue = n;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public void setMaxInterval(int n) {
        this.maxInterval = n;
    }

    public int getMaxInterval() {
        return this.maxInterval;
    }

    public boolean isNextEnabled(boolean bl) {
        double d = this.actualDensity * 0.9 + (bl ? 0.1 : 0.0);
        if (bl && d > this.desiredDensity * 0.7 + 0.3) {
            bl = false;
        } else if (!bl && d < this.desiredDensity * 0.7) {
            bl = true;
        }
        this.actualDensity = this.actualDensity * 0.9 + (bl ? 0.1 : 0.0);
        return bl;
    }

    public int randomPowerOf2(int n) {
        return 1 << (int)(this.random.nextDouble() * (double)(n + 1));
    }

    public int randomEvenInterval() {
        return (int)(this.random.nextDouble() * (double)(this.maxInterval * 2 + 1)) - this.maxInterval;
    }

    void calcNewOffset() {
        this.offset = this.randomEvenInterval();
    }

    public void randomize() {
        this.delay = this.randomPowerOf2(4);
        this.calcNewOffset();
    }

    public int next() {
        if (this.countdown-- < 0) {
            this.randomize();
            this.countdown = this.randomPowerOf2(3);
        }
        return this.nextValue();
    }

    public int next(int n) {
        int n2 = n % this.beatsPerMeasure;
        switch (n2) {
            case 0: {
                if (!(Math.random() < 0.9)) break;
                this.randomize();
                break;
            }
            case 2: 
            case 6: {
                if (!(Math.random() < 0.15)) break;
                this.randomize();
                break;
            }
            case 4: {
                if (!(Math.random() < 0.3)) break;
                this.randomize();
                break;
            }
            default: {
                if (!(Math.random() < 0.07)) break;
                this.randomize();
            }
        }
        return this.nextValue();
    }

    public int nextValue() {
        int n;
        int n2 = this.cursor - this.delay;
        if (n2 < 0) {
            n2 += this.values.length;
        }
        int n3 = 0;
        for (n = 100; n > 0 && ((n3 = this.values[n2] + this.offset) < 0 || n3 >= this.maxValue); --n) {
            if (n3 > this.maxValue + this.maxInterval - 1) {
                n3 = this.maxValue;
                break;
            }
            this.calcNewOffset();
        }
        if (n <= 0) {
            System.err.println("RecursiveSequence: nextValue timed out. offset = " + this.offset);
            n3 = this.maxValue / 2;
            this.offset = 0;
        }
        this.values[this.cursor] = n3;
        boolean bl = this.enables[this.cursor] = this.isNextEnabled(this.enables[n2]);
        ++this.cursor;
        if (this.cursor >= this.values.length) {
            this.cursor = 0;
        }
        return bl ? n3 : -1;
    }

    public Random getRandom() {
        return this.random;
    }

    public void setRandom(Random random) {
        this.random = random;
    }
}

