/*
 * Decompiled with CFR 0.152.
 */
package java.time;

import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.chrono.Chronology;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.TextStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries;
import java.time.temporal.TemporalQuery;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.time.temporal.ValueRange;
import java.util.Locale;

public enum Month implements TemporalAccessor,
TemporalAdjuster
{
    JANUARY,
    FEBRUARY,
    MARCH,
    APRIL,
    MAY,
    JUNE,
    JULY,
    AUGUST,
    SEPTEMBER,
    OCTOBER,
    NOVEMBER,
    DECEMBER;

    private static final Month[] ENUMS;

    public static Month of(int n) {
        if (n < 1 || n > 12) {
            throw new DateTimeException("Invalid value for MonthOfYear: " + n);
        }
        return ENUMS[n - 1];
    }

    public static Month from(TemporalAccessor temporalAccessor) {
        if (temporalAccessor instanceof Month) {
            return (Month)temporalAccessor;
        }
        try {
            if (!IsoChronology.INSTANCE.equals(Chronology.from(temporalAccessor))) {
                temporalAccessor = LocalDate.from(temporalAccessor);
            }
            return Month.of(temporalAccessor.get(ChronoField.MONTH_OF_YEAR));
        }
        catch (DateTimeException dateTimeException) {
            throw new DateTimeException("Unable to obtain Month from TemporalAccessor: " + temporalAccessor + " of type " + temporalAccessor.getClass().getName(), dateTimeException);
        }
    }

    public int getValue() {
        return this.ordinal() + 1;
    }

    public String getDisplayName(TextStyle textStyle, Locale locale) {
        return new DateTimeFormatterBuilder().appendText((TemporalField)ChronoField.MONTH_OF_YEAR, textStyle).toFormatter(locale).format(this);
    }

    @Override
    public boolean isSupported(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            return temporalField == ChronoField.MONTH_OF_YEAR;
        }
        return temporalField != null && temporalField.isSupportedBy(this);
    }

    @Override
    public ValueRange range(TemporalField temporalField) {
        if (temporalField == ChronoField.MONTH_OF_YEAR) {
            return temporalField.range();
        }
        return TemporalAccessor.super.range(temporalField);
    }

    @Override
    public int get(TemporalField temporalField) {
        if (temporalField == ChronoField.MONTH_OF_YEAR) {
            return this.getValue();
        }
        return TemporalAccessor.super.get(temporalField);
    }

    @Override
    public long getLong(TemporalField temporalField) {
        if (temporalField == ChronoField.MONTH_OF_YEAR) {
            return this.getValue();
        }
        if (temporalField instanceof ChronoField) {
            throw new UnsupportedTemporalTypeException("Unsupported field: " + temporalField);
        }
        return temporalField.getFrom(this);
    }

    public Month plus(long l) {
        int n = (int)(l % 12L);
        return ENUMS[(this.ordinal() + (n + 12)) % 12];
    }

    public Month minus(long l) {
        return this.plus(-(l % 12L));
    }

    public int length(boolean bl) {
        switch (this) {
            case FEBRUARY: {
                return bl ? 29 : 28;
            }
            case APRIL: 
            case JUNE: 
            case SEPTEMBER: 
            case NOVEMBER: {
                return 30;
            }
        }
        return 31;
    }

    public int minLength() {
        switch (this) {
            case FEBRUARY: {
                return 28;
            }
            case APRIL: 
            case JUNE: 
            case SEPTEMBER: 
            case NOVEMBER: {
                return 30;
            }
        }
        return 31;
    }

    public int maxLength() {
        switch (this) {
            case FEBRUARY: {
                return 29;
            }
            case APRIL: 
            case JUNE: 
            case SEPTEMBER: 
            case NOVEMBER: {
                return 30;
            }
        }
        return 31;
    }

    public int firstDayOfYear(boolean bl) {
        int n = bl ? 1 : 0;
        switch (this) {
            case JANUARY: {
                return 1;
            }
            case FEBRUARY: {
                return 32;
            }
            case MARCH: {
                return 60 + n;
            }
            case APRIL: {
                return 91 + n;
            }
            case MAY: {
                return 121 + n;
            }
            case JUNE: {
                return 152 + n;
            }
            case JULY: {
                return 182 + n;
            }
            case AUGUST: {
                return 213 + n;
            }
            case SEPTEMBER: {
                return 244 + n;
            }
            case OCTOBER: {
                return 274 + n;
            }
            case NOVEMBER: {
                return 305 + n;
            }
        }
        return 335 + n;
    }

    public Month firstMonthOfQuarter() {
        return ENUMS[this.ordinal() / 3 * 3];
    }

    @Override
    public <R> R query(TemporalQuery<R> temporalQuery) {
        if (temporalQuery == TemporalQueries.chronology()) {
            return (R)IsoChronology.INSTANCE;
        }
        if (temporalQuery == TemporalQueries.precision()) {
            return (R)ChronoUnit.MONTHS;
        }
        return TemporalAccessor.super.query(temporalQuery);
    }

    @Override
    public Temporal adjustInto(Temporal temporal) {
        if (!Chronology.from(temporal).equals(IsoChronology.INSTANCE)) {
            throw new DateTimeException("Adjustment only supported on ISO date-time");
        }
        return temporal.with(ChronoField.MONTH_OF_YEAR, this.getValue());
    }

    static {
        ENUMS = Month.values();
    }
}

