/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.ports.UnitOutputPort;
import com.jsyn.ports.UnitVariablePort;
import com.jsyn.unitgen.UnitGenerator;

public class PeakFollower
extends UnitGenerator {
    public UnitInputPort input = new UnitInputPort("Input");
    public UnitVariablePort current;
    public UnitInputPort halfLife;
    public UnitOutputPort output;
    private double previousHalfLife = -1.0;
    private double decayScalar = 0.99;

    public PeakFollower() {
        this.addPort(this.input);
        this.halfLife = new UnitInputPort(1, "HalfLife", 0.1);
        this.addPort(this.halfLife);
        this.current = new UnitVariablePort("Current");
        this.addPort(this.current);
        this.output = new UnitOutputPort("Output");
        this.addPort(this.output);
    }

    @Override
    public void generate(int n, int n2) {
        double[] dArray = this.input.getValues();
        double[] dArray2 = this.output.getValues();
        double d = this.halfLife.getValues()[0];
        double d2 = this.current.getValue();
        if (d != this.previousHalfLife) {
            this.decayScalar = this.convertHalfLifeToMultiplier(d);
            this.previousHalfLife = d;
        }
        double d3 = 1.0 - this.decayScalar;
        for (int i = n; i < n2; ++i) {
            double d4 = dArray[i];
            if (d4 < 0.0) {
                d4 = -d4;
            }
            d2 = d4 >= d2 ? d4 : (d2 *= d3);
            dArray2[i] = d2;
        }
        if (d2 < 1.0E-26) {
            d2 = 0.0;
        }
        this.current.setValue(d2);
    }
}

