/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.data.SpectralWindow;
import com.jsyn.data.Spectrum;
import com.jsyn.ports.UnitInputPort;
import com.jsyn.ports.UnitSpectralOutputPort;
import com.jsyn.unitgen.RectangularWindow;
import com.jsyn.unitgen.UnitGenerator;
import com.softsynth.math.FourierMath;
import java.util.Arrays;

public class SpectralFFT
extends UnitGenerator {
    public UnitInputPort input;
    public UnitSpectralOutputPort output;
    private double[] buffer;
    private int cursor;
    private SpectralWindow window = RectangularWindow.getInstance();
    private int sizeLog2;
    private int offset;
    private boolean running;

    public SpectralFFT() {
        this(9);
    }

    public SpectralFFT(int n) {
        this.input = new UnitInputPort("Input");
        this.addPort(this.input);
        this.output = new UnitSpectralOutputPort("Output", 1 << n);
        this.addPort(this.output);
        this.setSizeLog2(n);
    }

    public void setSizeLog2(int n) {
        this.sizeLog2 = n;
        this.output.setSize(1 << n);
        this.buffer = this.output.getSpectrum().getReal();
        this.cursor = 0;
    }

    public int getSizeLog2() {
        return this.sizeLog2;
    }

    @Override
    public void generate(int n, int n2) {
        if (!this.running) {
            int n3 = (1 << this.sizeLog2) - 1;
            if ((this.getSynthesisEngine().getFrameCount() - (long)this.offset & (long)n3) == 0L) {
                this.running = true;
                this.cursor = 0;
            }
        }
        if (this.running) {
            double[] dArray = this.input.getValues();
            for (int i = n; i < n2; ++i) {
                this.buffer[this.cursor] = dArray[i] * this.window.get(this.cursor);
                ++this.cursor;
                if (this.cursor != this.buffer.length) continue;
                Spectrum spectrum = this.output.getSpectrum();
                Arrays.fill(spectrum.getImaginary(), 0.0);
                FourierMath.fft(this.buffer.length, spectrum.getReal(), spectrum.getImaginary());
                this.output.advance();
                this.cursor = 0;
            }
        }
    }

    public SpectralWindow getWindow() {
        return this.window;
    }

    public void setWindow(SpectralWindow spectralWindow) {
        this.window = spectralWindow;
    }

    public void setOffset(int n) {
        this.offset = n;
    }

    public int getOffset() {
        return this.offset;
    }
}

