/*
 * Decompiled with CFR 0.152.
 */
package processing.sound;

import com.jsyn.engine.SynthesisEngine;
import com.jsyn.unitgen.Circuit;
import com.jsyn.unitgen.MixerMono;
import com.jsyn.unitgen.PassThrough;
import com.jsyn.unitgen.UnitFilter;
import com.jsyn.unitgen.UnitGenerator;
import processing.sound.JSynAllPass;
import processing.sound.JSynLBCF;

class JSynReverb
extends UnitFilter {
    private Circuit reverbCircuit;
    private static int[] Ns = new int[]{1557, 1617, 1491, 1422, 1277, 1356, 1188, 1116};
    private JSynLBCF[] lbcfs = new JSynLBCF[Ns.length];
    private static int[] As = new int[]{225, 556, 441, 341};
    private MixerMono mixer;

    public JSynReverb() {
        int n;
        this.reverbCircuit = new Circuit();
        PassThrough passThrough = new PassThrough();
        this.reverbCircuit.add((UnitGenerator)passThrough);
        this.input = passThrough.input;
        JSynAllPass jSynAllPass = new JSynAllPass(0.5, As[0]);
        this.reverbCircuit.add((UnitGenerator)jSynAllPass);
        JSynAllPass jSynAllPass2 = jSynAllPass;
        for (n = 1; n < As.length; ++n) {
            JSynAllPass jSynAllPass3 = new JSynAllPass(0.5, As[n]);
            jSynAllPass2.output.connect(jSynAllPass3.input);
            jSynAllPass2 = jSynAllPass3;
            this.reverbCircuit.add((UnitGenerator)jSynAllPass2);
        }
        for (n = 0; n < Ns.length; ++n) {
            this.lbcfs[n] = new JSynLBCF(0.84, 0.2, Ns[n]);
            this.reverbCircuit.add((UnitGenerator)this.lbcfs[n]);
            this.lbcfs[n].input.connect(passThrough.output);
            this.lbcfs[n].output.connect(jSynAllPass.input);
        }
        this.mixer = new MixerMono(2);
        this.mixer.amplitude.set(1.0);
        this.setWet(0.5f);
        passThrough.output.connect(0, this.mixer.input, 0);
        jSynAllPass2.output.connect(0, this.mixer.input, 1);
        this.output = this.mixer.output;
    }

    public void setSynthesisEngine(SynthesisEngine synthesisEngine) {
        this.reverbCircuit.setSynthesisEngine(synthesisEngine);
    }

    public void generate(int n, int n2) {
    }

    protected void setDamp(float f) {
        for (JSynLBCF jSynLBCF : this.lbcfs) {
            jSynLBCF.setD((double)f * 0.4);
        }
    }

    protected void setRoom(float f) {
        for (JSynLBCF jSynLBCF : this.lbcfs) {
            jSynLBCF.setF((double)f * 0.28 + 0.7);
        }
    }

    protected void setWet(float f) {
        this.mixer.gain.set(0, (double)(1.0f - f));
        this.mixer.gain.set(1, (double)f);
    }
}

