/*
 * Decompiled with CFR 0.152.
 */
package java.time.chrono;

import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.chrono.AbstractChronology;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateTimeImpl;
import java.time.chrono.ChronoZonedDateTime;
import java.time.chrono.Chronology;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries;
import java.time.temporal.TemporalQuery;
import java.time.temporal.TemporalUnit;
import java.util.Comparator;
import java.util.Objects;

public interface ChronoLocalDateTime<D extends ChronoLocalDate>
extends Temporal,
TemporalAdjuster,
Comparable<ChronoLocalDateTime<?>> {
    public static Comparator<ChronoLocalDateTime<?>> timeLineOrder() {
        return AbstractChronology.DATE_TIME_ORDER;
    }

    public static ChronoLocalDateTime<?> from(TemporalAccessor temporalAccessor) {
        if (temporalAccessor instanceof ChronoLocalDateTime) {
            return (ChronoLocalDateTime)temporalAccessor;
        }
        Objects.requireNonNull(temporalAccessor, "temporal");
        Chronology chronology = temporalAccessor.query(TemporalQueries.chronology());
        if (chronology == null) {
            throw new DateTimeException("Unable to obtain ChronoLocalDateTime from TemporalAccessor: " + temporalAccessor.getClass());
        }
        return chronology.localDateTime(temporalAccessor);
    }

    default public Chronology getChronology() {
        return this.toLocalDate().getChronology();
    }

    public D toLocalDate();

    public LocalTime toLocalTime();

    @Override
    public boolean isSupported(TemporalField var1);

    @Override
    default public boolean isSupported(TemporalUnit temporalUnit) {
        if (temporalUnit instanceof ChronoUnit) {
            return temporalUnit != ChronoUnit.FOREVER;
        }
        return temporalUnit != null && temporalUnit.isSupportedBy(this);
    }

    @Override
    default public ChronoLocalDateTime<D> with(TemporalAdjuster temporalAdjuster) {
        return ChronoLocalDateTimeImpl.ensureValid(this.getChronology(), Temporal.super.with(temporalAdjuster));
    }

    @Override
    public ChronoLocalDateTime<D> with(TemporalField var1, long var2);

    @Override
    default public ChronoLocalDateTime<D> plus(TemporalAmount temporalAmount) {
        return ChronoLocalDateTimeImpl.ensureValid(this.getChronology(), Temporal.super.plus(temporalAmount));
    }

    @Override
    public ChronoLocalDateTime<D> plus(long var1, TemporalUnit var3);

    @Override
    default public ChronoLocalDateTime<D> minus(TemporalAmount temporalAmount) {
        return ChronoLocalDateTimeImpl.ensureValid(this.getChronology(), Temporal.super.minus(temporalAmount));
    }

    @Override
    default public ChronoLocalDateTime<D> minus(long l, TemporalUnit temporalUnit) {
        return ChronoLocalDateTimeImpl.ensureValid(this.getChronology(), Temporal.super.minus(l, temporalUnit));
    }

    @Override
    default public <R> R query(TemporalQuery<R> temporalQuery) {
        if (temporalQuery == TemporalQueries.zoneId() || temporalQuery == TemporalQueries.zone() || temporalQuery == TemporalQueries.offset()) {
            return null;
        }
        if (temporalQuery == TemporalQueries.localTime()) {
            return (R)this.toLocalTime();
        }
        if (temporalQuery == TemporalQueries.chronology()) {
            return (R)this.getChronology();
        }
        if (temporalQuery == TemporalQueries.precision()) {
            return (R)ChronoUnit.NANOS;
        }
        return temporalQuery.queryFrom(this);
    }

    @Override
    default public Temporal adjustInto(Temporal temporal) {
        return temporal.with(ChronoField.EPOCH_DAY, this.toLocalDate().toEpochDay()).with(ChronoField.NANO_OF_DAY, this.toLocalTime().toNanoOfDay());
    }

    default public String format(DateTimeFormatter dateTimeFormatter) {
        Objects.requireNonNull(dateTimeFormatter, "formatter");
        return dateTimeFormatter.format(this);
    }

    public ChronoZonedDateTime<D> atZone(ZoneId var1);

    default public Instant toInstant(ZoneOffset zoneOffset) {
        return Instant.ofEpochSecond(this.toEpochSecond(zoneOffset), this.toLocalTime().getNano());
    }

    default public long toEpochSecond(ZoneOffset zoneOffset) {
        Objects.requireNonNull(zoneOffset, "offset");
        long l = this.toLocalDate().toEpochDay();
        long l2 = l * 86400L + (long)this.toLocalTime().toSecondOfDay();
        return l2 -= (long)zoneOffset.getTotalSeconds();
    }

    @Override
    default public int compareTo(ChronoLocalDateTime<?> chronoLocalDateTime) {
        int n = this.toLocalDate().compareTo((ChronoLocalDate)chronoLocalDateTime.toLocalDate());
        if (n == 0 && (n = this.toLocalTime().compareTo(chronoLocalDateTime.toLocalTime())) == 0) {
            n = this.getChronology().compareTo(chronoLocalDateTime.getChronology());
        }
        return n;
    }

    default public boolean isAfter(ChronoLocalDateTime<?> chronoLocalDateTime) {
        long l;
        long l2 = this.toLocalDate().toEpochDay();
        return l2 > (l = chronoLocalDateTime.toLocalDate().toEpochDay()) || l2 == l && this.toLocalTime().toNanoOfDay() > chronoLocalDateTime.toLocalTime().toNanoOfDay();
    }

    default public boolean isBefore(ChronoLocalDateTime<?> chronoLocalDateTime) {
        long l;
        long l2 = this.toLocalDate().toEpochDay();
        return l2 < (l = chronoLocalDateTime.toLocalDate().toEpochDay()) || l2 == l && this.toLocalTime().toNanoOfDay() < chronoLocalDateTime.toLocalTime().toNanoOfDay();
    }

    default public boolean isEqual(ChronoLocalDateTime<?> chronoLocalDateTime) {
        return this.toLocalTime().toNanoOfDay() == chronoLocalDateTime.toLocalTime().toNanoOfDay() && this.toLocalDate().toEpochDay() == chronoLocalDateTime.toLocalDate().toEpochDay();
    }

    public boolean equals(Object var1);

    public int hashCode();

    public String toString();
}

